(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      6382,        219]*)
(*NotebookOutlinePosition[      7062,        242]*)
(*  CellTagsIndexPosition[      7018,        238]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(\(g[x_, y_] = \(-3\) + 4  x + 8  x^2 - 12  x^3 + 3  x^4 + 14  y^2 - 
          20  x\ y^2 + 8\ x^2\ y^2 + 5  y^4;\)\)], "Input"],

Cell[BoxData[
    \(\(\(\ \)\(g[3/2, \@3/2]\)\)\)], "Input"],

Cell[BoxData[
    \(\(h[x_] = g[x, y[x]];\)\)], "Input"],

Cell[BoxData[
    \(\(y''\)[
        x_] = \(y''\)[
          x] /. \(Solve[\(h''\)[x] \[Equal] 0, \(y''\)[
              x]]\)[\([1]\)]\)], "Input"],

Cell[BoxData[
    \(\(y'\)[
        x_] = \(y'\)[
          x] /. \(Solve[\(h'\)[x] \[Equal] 0, \(y'\)[
              x]]\)[\([1]\)]\)], "Input"],

Cell[BoxData[
    \(\(\(\(y'\)[3/2]\)\(\ \)\)\)], "Input"],

Cell[BoxData[
    \(\(y'\)[3/2]\  /. \ y[3/2] -> \@3/2\)], "Input"],

Cell[BoxData[
    \(\(y''\)[3/2]\  /. \ y[3/2] -> \@3/2\)], "Input"],

Cell[BoxData[
    \(<< Graphics`ImplicitPlot`\)], "Input"],

Cell[BoxData[
    \(\(ImplicitPlot[g[x, y] \[Equal] 0, {x, \(-1\), 4}];\)\)], "Input"],

Cell[BoxData[
    \(Clear["\<Global`*\>"]\)], "Input"],

Cell[BoxData[
    \(\(f[x_, y_] = x^2\  - \ y^2;\)\)], "Input"],

Cell[BoxData[
    \(\(Plot3D[f[x, y], {x, \(-1\), 1}, {y, \(-1\), 1}];\)\)], "Input"],

Cell[BoxData[
    \(\(ParametricPlot3D[{Cos[t], Sin[t], 
          Cos[2  t]}, {t, \(-\[Pi]\), \[Pi]}];\)\)], "Input"],

Cell[BoxData[
    \(\(ParametricPlot3D[{Cos[t], Sin[t], 
          u*Cos[2  t]}, {t, \(-\[Pi]\), \[Pi]}, {u, 0, 1}, 
        PlotPoints \[Rule] 50];\)\)], "Input"],

Cell[BoxData[
    \(Clear["\<Global`*\>"]\)], "Input"],

Cell["\<\
Calcular los extremos absolutos de la funci\[OAcute]n f con la condici\
\[OAcute]n g(x,y)=0 siendo:\
\>", "Text"],

Cell[BoxData[{
    \(\(f[x_, y_] = x^2\  + \ y^2;\)\), "\[IndentingNewLine]", 
    \(\(g[x_, y_] = 
        1 + 2  x\  - 2  x^2 - \ 2  x^3 + x^4 + 2  y + 4  x\ y - 2  x^2\ \ y - 
          2  y^2 - 2\ x\ \ y^2\  + \ 2  x^2\ y^2 - 2  y^3 + 
          y^4;\)\)}], "Input"],

Cell["Definimos la funci\[OAcute]n de Lagrange y su gradiente", "Text"],

Cell[BoxData[{
    \(\(F[x_, y_, \[Lambda]_] = 
        f[x, y] + \[Lambda]*g[x, y];\)\), "\[IndentingNewLine]", 
    \(\(gradF[x_, y_, \[Lambda]_] = {D[F[x, y, \[Lambda]], x], 
          D[F[x, y, \[Lambda]], y], 
          D[F[x, y, \[Lambda]], \[Lambda]]};\)\)}], "Input"],

Cell["Calculamos los puntos cr\[IAcute]ticos de la funci\[OAcute]n de \
Lagrange", "Text"],

Cell[BoxData[
    \(sol = 
      Solve[gradF[x, y, \[Lambda]] \[Equal] {0, 0, 0}, {x, 
          y, \[Lambda]}]\)], "Input"],

Cell[BoxData[
    \(pcrit = {x, y} /. sol\)], "Input"],

Cell[BoxData[
    \(f[x, y] /. sol\)], "Input"],

Cell[BoxData[
    \(% // N\)], "Input"],

Cell["\<\
Hay dos puntos en los que se alcanza un m\[AAcute]ximo absoluto y otros dos \
en los que se alcanza un m\[IAcute]nimo absoluto. Observaa que lo que hemos \
calculado es la distancia m\[IAcute]nima y m\[AAcute]xima del origen a la \
curva g(x,y)=0.\
\>", "Text"],

Cell[BoxData[
    \(Clear["\<Global`*\>"]\)], "Input"],

Cell[BoxData[
    \(\(g[x_, y_, z_] = 
        1 - x^2 - 2  x\ y + 2\ x^3\ y - y^2\  + \ 2  x\ y^3 - 2\ z\  + 
          2  x\ y\ z^2;\)\)], "Input"],

Cell[BoxData[
    \(g[1/\@2, 1/\@2, 0]\)], "Input"],

Cell[BoxData[
    \(\(\(D[g[x, y, z], z] /. x \[Rule] 1/\@2\) /. y \[Rule] 1/\@2\) /. 
      z \[Rule] \ 0\)], "Input"],

Cell[BoxData[
    \(Solve[D[g[x, y, z[x, y]], x, x] \[Equal] 0, 
      D[z[x, y], x, x]]\)], "Input"],

Cell[BoxData[
    \(Solve[D[g[x, y, z[x, y]], x] \[Equal] 0, D[z[x, y], x]]\)], "Input"],

Cell[BoxData[
    \(Clear["\<Global`*\>"]\)], "Input"],

Cell[BoxData[
    \(f[x_, y_, z_] = x^3 + y^3 + z^3; \ 
    g\ [x_, y_, z_] = 4  x^2 + 9  y^2 + 16  z^2 - 25;\)], "Input"],

Cell[BoxData[
    \(\(F[x_, y_, z_, \[Lambda]_] = 
        f[x, y, z] + \[Lambda]\ *g[x, y, z];\)\)], "Input"],

Cell[BoxData[
    \(\(gradF[x_, y_, z_, \[Lambda]_] := {D[F[x, y, z, \[Lambda]], x], 
          D[F[x, y, z, \[Lambda]], y], D[F[x, y, z, \[Lambda]], z], 
          D[F[x, y, z, \[Lambda]], \[Lambda]]};\)\)], "Input"],

Cell[BoxData[
    \(sol = 
      Solve[gradF[x, y, z, \[Lambda]] \[Equal] {0, 0, 0, 0}, {x, y, 
          z, \[Lambda]}]\)], "Input"],

Cell[BoxData[
    \(pcritic = {x, y, z} /. sol\)], "Input"],

Cell[BoxData[
    \(valores = Apply[f, pcritic, 1]\)], "Input"],

Cell[BoxData[
    \(Max[valores]\)], "Input"],

Cell[BoxData[
    \(Min[valores]\)], "Input"],

Cell[BoxData[
    \(pcriticpos = 
      Cases[{x, y, z} /. sol, 
        x_?\((#1[\([1]\)] \[GreaterEqual] \ 
                  0\  && \ #1[\([2]\)] \[GreaterEqual] \ 
                  0\  && \ #1[\([3]\)] \[GreaterEqual] \ 0 &)\)]\)], "Input"],

Cell[BoxData[
    \(Apply[f, %, 1]\)], "Input"]
},
FrontEndVersion->"4.2 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 681}},
WindowSize->{1016, 643},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 148, 2, 50, "Input"],
Cell[1905, 55, 60, 1, 55, "Input"],
Cell[1968, 58, 56, 1, 50, "Input"],
Cell[2027, 61, 149, 4, 50, "Input"],
Cell[2179, 67, 145, 4, 50, "Input"],
Cell[2327, 73, 58, 1, 50, "Input"],
Cell[2388, 76, 67, 1, 55, "Input"],
Cell[2458, 79, 68, 1, 55, "Input"],
Cell[2529, 82, 58, 1, 50, "Input"],
Cell[2590, 85, 86, 1, 50, "Input"],
Cell[2679, 88, 54, 1, 50, "Input"],
Cell[2736, 91, 63, 1, 50, "Input"],
Cell[2802, 94, 85, 1, 50, "Input"],
Cell[2890, 97, 118, 2, 50, "Input"],
Cell[3011, 101, 163, 3, 50, "Input"],
Cell[3177, 106, 54, 1, 50, "Input"],
Cell[3234, 109, 123, 3, 29, "Text"],
Cell[3360, 114, 270, 5, 70, "Input"],
Cell[3633, 121, 71, 0, 29, "Text"],
Cell[3707, 123, 275, 5, 70, "Input"],
Cell[3985, 130, 90, 1, 29, "Text"],
Cell[4078, 133, 124, 3, 50, "Input"],
Cell[4205, 138, 54, 1, 50, "Input"],
Cell[4262, 141, 47, 1, 50, "Input"],
Cell[4312, 144, 39, 1, 50, "Input"],
Cell[4354, 147, 271, 5, 48, "Text"],
Cell[4628, 154, 54, 1, 50, "Input"],
Cell[4685, 157, 149, 3, 50, "Input"],
Cell[4837, 162, 51, 1, 55, "Input"],
Cell[4891, 165, 119, 2, 55, "Input"],
Cell[5013, 169, 101, 2, 50, "Input"],
Cell[5117, 173, 88, 1, 50, "Input"],
Cell[5208, 176, 54, 1, 50, "Input"],
Cell[5265, 179, 122, 2, 50, "Input"],
Cell[5390, 183, 110, 2, 50, "Input"],
Cell[5503, 187, 217, 3, 50, "Input"],
Cell[5723, 192, 133, 3, 50, "Input"],
Cell[5859, 197, 59, 1, 50, "Input"],
Cell[5921, 200, 63, 1, 50, "Input"],
Cell[5987, 203, 45, 1, 50, "Input"],
Cell[6035, 206, 45, 1, 50, "Input"],
Cell[6083, 209, 245, 5, 50, "Input"],
Cell[6331, 216, 47, 1, 50, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

